import { faLambda } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Popover } from '@yandex-cloud/uikit';
import { Collapse } from '@yandex-data-ui/common';
import { classNames, Json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { createPodSummaryKey, ReplicaSetStatusView } from '../../../../../../../../models/ui/status';
import { PodsSummaryLine } from '../PodsSummaryLine/PodsSummaryLine';

import classes from './MergePodInfo.module.css';

export const MergePodInfo: React.FC<{ replicaSetStatusView: ReplicaSetStatusView }> = ({ replicaSetStatusView }) => {
   const { podsSummary, actualPodsSummary, mergePodsSummary } = replicaSetStatusView;
   const rsKey = createPodSummaryKey(podsSummary);
   const mergeKey = createPodSummaryKey(mergePodsSummary);

   const list = [
      ['RS status count', podsSummary],
      ['Merge count', mergePodsSummary],
      ['Visible pods', actualPodsSummary],
   ] as const;

   const existDiff = rsKey !== mergeKey;

   const content = (
      <div style={{ minWidth: '300px' }}>
         <strong>Merge pod count</strong>
         {list.map(([title, summary]) => (
            <p key={title}>
               {title}
               <PodsSummaryLine podsSummary={summary} />
               <Collapse title={<span>JSON</span>}>
                  <Json obj={summary} />
               </Collapse>
            </p>
         ))}
      </div>
   );
   return (
      <Popover content={content}>
         <span className={classNames(classes.calcPodMark, existDiff ? classes.diffMark : undefined)}>
            <FontAwesomeIcon icon={faLambda} />
         </span>
      </Popover>
   );
};
