import { faLambda } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { Popover } from '@yandex-cloud/uikit';
import { Collapse } from '@yandex-data-ui/common';
import { classNames, Json } from '@yandex-infracloud-ui/libs';
import React, { useMemo } from 'react';

import { Status } from '../../../../../../../../components/lib';
import { getUIStatusData } from '../../../../../../../../models/ui/runtimeDeploy/status';

import { ReplicaSetStatusView } from '../../../../../../../../models/ui/status';

import classes from './MergeStatusInfo.module.css';

export const MergeStatusInfo: React.FC<{ replicaSetStatusView: ReplicaSetStatusView; existErrors: boolean }> = ({
   replicaSetStatusView,
   existErrors,
}) => {
   const { statusStateInfo, mergeStatusStateInfo } = replicaSetStatusView;
   const statusData = useMemo(
      () =>
         getUIStatusData({
            state: null,
            statusStateInfo,
            existErrors,
            statusMap: {},
         }),
      [existErrors, statusStateInfo],
   );
   const mergeStatusData = useMemo(
      () =>
         getUIStatusData({
            state: null,
            statusStateInfo: mergeStatusStateInfo,
            existErrors,
            statusMap: {},
         }),
      [existErrors, mergeStatusStateInfo],
   );

   const list = [
      ['RS Status', statusData, statusStateInfo],
      ['Merge Status', mergeStatusData, mergeStatusStateInfo],
   ] as const;

   const content = (
      <div>
         {list.map(([title, data, info]) => (
            <p key={title}>
               <strong>{title}</strong>
               <div>
                  <Status state={data.statusState}>{data.message}</Status>
               </div>
               <Collapse title={<span>JSON</span>}>
                  <Json obj={{ info, uiStatusData: data }} />
               </Collapse>
            </p>
         ))}
      </div>
   );

   const existDiff = statusData.statusState !== mergeStatusData.statusState;
   return (
      <Popover content={content}>
         <span className={classNames(classes.calcPodMark, existDiff ? classes.diffMark : undefined)}>
            <FontAwesomeIcon icon={faLambda} />
         </span>
      </Popover>
   );
};
