import React from 'react';

import { Progress } from '@yandex-cloud/uikit';

import { ReplicaSetPodsSummary } from '../../../../../../../../models/ui';

interface Props {
   podsSummary: ReplicaSetPodsSummary;
}

const colors = {
   ready: 'var(--yc-color-infographics-positive-heavy)',
   inProgress: 'var(--yc-color-infographics-info-heavy)',
   failed: 'var(--yc-color-infographics-danger-heavy)',
   oldReady: 'var(--yc-color-infographics-positive-medium)',
   oldInProgress: 'var(--yc-color-infographics-info-medium)',
   oldFailed: 'var(--yc-color-infographics-danger-medium)',
   unavailable: 'var(--yc-color-shadow)',
   unknown: 'var(--yc-color-shadow)',
};

export const PodsSummaryLine: React.FC<Props> = React.memo(({ podsSummary }) => {
   const { total } = podsSummary;
   const k = 100 / total;
   const podsStack = [
      {
         value: podsSummary.ready,
         color: colors.ready,
      },
      {
         value: podsSummary.inProgress,
         color: colors.inProgress,
      },
      {
         value: podsSummary.failed,
         color: colors.failed,
      },
      {
         value: podsSummary.oldReady,
         color: colors.oldReady,
      },
      {
         value: podsSummary.oldInProgress,
         color: colors.oldInProgress,
      },
      {
         value: podsSummary.oldFailed,
         color: colors.oldFailed,
      },
      {
         value: podsSummary.unavailable,
         color: colors.unavailable,
      },
      {
         value: podsSummary.unknown,
         color: colors.unknown,
      },
   ]
      .filter(e => e.value)
      .map(e => {
         e.value *= k;
         return e;
      });

   return <Progress stack={podsStack} view={'thinnest'} />;
});
