import React from 'react';

import { Button } from '@yandex-cloud/uikit';
import { Loader } from '@yandex-infracloud-ui/libs';
import { useYpErrorModal } from '../../../../../../../../components/network/YpErrorModal/useYpErrorModal';
import { NetworkError, NetworkRequest } from '../../../../../../../../redux/slices/network/model';
import classes from './ReplicaSetPending.module.css';

interface Props {
   error: NetworkError;
   request?: NetworkRequest;
}

export const ReplicaSetPending: React.FC<Props> = React.memo(({ error, request }) => {
   const onOpenModal = useYpErrorModal({ error, request });

   return (
      <div className={classes.pending}>
         <div className={classes.textWrapper}>
            <Loader inline={true} />
            <span>Replica set does not exists</span>
         </div>
         <Button onClick={onOpenModal}>Show more</Button>
      </div>
   );
});
