import { Meta } from '@storybook/react';
import React from 'react';
import { apiServicesContextDecorator, routerDecorator } from '../../../../../../../../stories';

import { ReplicaSetRevision } from './ReplicaSetRevision';

export const Regular = () => (
   <>
      <div>
         Empty
         <ReplicaSetRevision currentRevision={null} targetRevision={null} />
      </div>
      <br />
      <div>
         Ready
         <ReplicaSetRevision currentRevision={7} targetRevision={7} />
      </div>
      <br />
      <div>
         In Progress
         <ReplicaSetRevision currentRevision={7} targetRevision={7} inProgress />
      </div>
      <br />
      <div>
         First
         <ReplicaSetRevision currentRevision={null} targetRevision={1} />
      </div>
      <br />
      <div>
         Unknown
         <ReplicaSetRevision currentRevision={1} targetRevision={null} />
      </div>
   </>
);

export default {
   decorators: [routerDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/status/components/ReplicaSetTile/components/ReplicaSetRevision',
} as Meta;
