import React from 'react';
import { faLongArrowRight } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';

import classes from './ReplicaSetRevision.module.css';

interface Props {
   currentRevision: number | null;
   targetRevision: number | null;
   inProgress?: boolean;
}

export const ReplicaSetRevision: React.FC<Props> = React.memo(
   ({ currentRevision, targetRevision, inProgress = false }) => (
      <div className={classes.revision}>
         {inProgress && currentRevision === targetRevision ? 'Target Rev' : 'Rev'}
         &nbsp;
         <span className={classes.number} data-test={'replica-set--revision'}>
            {currentRevision ?? 'N/A'}
         </span>
         {currentRevision !== targetRevision && (
            <>
               <span className={classes.arrow}>
                  <FontAwesomeIcon icon={faLongArrowRight} />
               </span>
               <span className={classes.number}>{targetRevision ?? 'N/A'}</span>
            </>
         )}
      </div>
   ),
);

ReplicaSetRevision.displayName = 'ReplicaSetRevision';
