import React from 'react';
import { PerClusterApprove } from '../../../../../../../../components';

import classes from './ReplicaSetApproves.module.css';

interface Props {
   needApproval: boolean;
   stageId: string;
   duId: string;
   location: string;
}

export const ReplicaSetApproves: React.FC<Props> = React.memo(({ needApproval, stageId, duId, location }) => {
   if (!needApproval) {
      return <span>—</span>;
   }

   return (
      <div className={classes.approves}>
         <PerClusterApprove stageId={stageId} duId={duId} cluster={location} />
      </div>
   );
});

ReplicaSetApproves.displayName = 'ReplicaSetApproves';
