import { Meta } from '@storybook/react';
import React from 'react';
import { apiServicesContextDecorator, routerDecorator } from '../../../../../../../../stories';

import { ReplicaSetEndpointSets } from './ReplicaSetEndpointSets';

const OneEndPointByClusterSet = {
   sas: new Set(['nikolaichev-stage-per-location.deployUnit']),
   vla: new Set(['nikolaichev-stage-per-location.deployUnit']),
   man: new Set(['nikolaichev-stage-per-location.deployUnit']),
};

const MultiEndPointByClusterSet = {
   sas: new Set(['nikolaichev-stage-per-location.deployUnit', 'nikolaichev-stage-per-location.deployUnit_2']),
   vla: new Set(['nikolaichev-stage-per-location.deployUnit', 'nikolaichev-stage-per-location.deployUnit_2']),
   man: new Set(['nikolaichev-stage-per-location.deployUnit', 'nikolaichev-stage-per-location.deployUnit_2']),
};

export const Regular = () => (
   <>
      <div>
         One endpoint by cluster
         <ReplicaSetEndpointSets endpointSets={OneEndPointByClusterSet} />
      </div>
      <br />
      <div>
         Multi endpoints by cluster
         <ReplicaSetEndpointSets endpointSets={MultiEndPointByClusterSet} />
      </div>
   </>
);

export default {
   decorators: [routerDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/status/components/ReplicaSets/components/ReplicaSetEndpointSets',
} as Meta;
