import { ClipboardButton } from '@yandex-cloud/uikit';
import React from 'react';

import classes from './ReplicaSetEndpointSets.module.scss';

interface Props {
   endpointSets: Record<string, Set<string>>;
}

export const ReplicaSetEndpointSets: React.FC<Props> = React.memo(({ endpointSets }) => (
   <div className={classes.endpointSets}>
      <table>
         <thead>
            <tr>
               <th>Cluster</th>
               <th>Endpoint set</th>
               <th aria-label={'Copy to clipboard'} />
            </tr>
         </thead>
         <tbody>
            {Object.keys(endpointSets).map(location => (
               <React.Fragment key={location}>
                  {Array.from(endpointSets[location].values()).map(id => (
                     <tr key={id}>
                        <td>{location}</td>
                        <td>{id}</td>
                        <td className={classes.copy}>
                           <ClipboardButton text={id} size={14} />
                        </td>
                     </tr>
                  ))}
               </React.Fragment>
            ))}
         </tbody>
      </table>
   </div>
));

ReplicaSetEndpointSets.displayName = 'ReplicaSetEndpointSets';
