import { Meta } from '@storybook/react';
import React from 'react';
import { ReplicaSetPodsSummary } from '../../../../../../../../models/ui';
import { apiServicesContextDecorator, routerDecorator } from '../../../../../../../../stories';

import { ReplicaSetStatuses } from './ReplicaSetStatuses';

const podsSummaryReady: ReplicaSetPodsSummary = {
   total: 3,
   ready: 3,
   inProgress: 0,
   failed: 0,
   oldReady: 0,
   oldInProgress: 0,
   oldFailed: 0,
   unavailable: 0,
   unknown: 0,
};

const podsSummaryProgress: ReplicaSetPodsSummary = {
   total: 9,
   ready: 4,
   inProgress: 2,
   failed: 0,
   oldReady: 3,
   oldInProgress: 0,
   oldFailed: 0,
   unavailable: 0,
   unknown: 0,
};

const podsSummaryAll: ReplicaSetPodsSummary = {
   total: 21,
   ready: 4,
   inProgress: 5,
   failed: 1,
   oldReady: 7,
   oldInProgress: 1,
   oldFailed: 1,
   unavailable: 1,
   unknown: 1,
};

export const Regular = () => (
   <>
      <div>
         All ready
         <ReplicaSetStatuses podsSummary={podsSummaryReady} />
      </div>
      <br />
      <div>
         Typical progress
         <ReplicaSetStatuses podsSummary={podsSummaryProgress} />
      </div>
      <br />
      <div>
         All
         <ReplicaSetStatuses podsSummary={podsSummaryAll} />
      </div>
   </>
);

export default {
   decorators: [routerDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/status/components/ReplicaSets/components/ReplicaSetStatuses',
} as Meta;
