import React, { ReactNode } from 'react';

import { IModalProps } from '@yandex-infracloud-ui/libs';

import { YpErrorHeader } from '../../../../../../components';
import { SimpleModal } from '../../../../../../components/lib';

interface Props extends IModalProps<void> {
   warningCount: number;
   title: string;
   id: string;
   location?: string;
   errors: ReactNode;
   additionalObjectData?: ReactNode;
}

export const RuntimeErrorModal: React.FC<Props> = ({
   warningCount,
   title,
   id,
   location,
   errors,
   ok,
   cancel,
   additionalObjectData,
}) => (
   <SimpleModal title={`${title} errors`} ok={ok} cancel={cancel}>
      <YpErrorHeader title={title} id={id} count={warningCount} location={location}>
         {additionalObjectData}
      </YpErrorHeader>
      {errors}
   </SimpleModal>
);
