import React from 'react';

import { Loader } from '@yandex-infracloud-ui/libs';

import { OrderList } from '../../../../../../components/lib';

import classes from './RuntimeObjectRevision.module.css';

interface Props {
   revision: number | null;
   targetRevision: number | null;
   progress: boolean;
   full?: boolean;
}

export const RuntimeObjectRevision: React.FC<Props> = React.memo(({ revision, targetRevision, progress, full }) => (
   <div className={classes.revision}>
      {full && 'Revision '}
      {revision ?? 'N/A'}
      {revision !== targetRevision && <OrderList items={[<span> </span>, targetRevision ?? 'N/A']} />}
      {(progress || revision !== targetRevision) && <Loader inline={true} />}
   </div>
));

RuntimeObjectRevision.displayName = 'RuntimeObjectRevision';
