import React, { useCallback } from 'react';

import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { faExclamationTriangle } from '@fortawesome/pro-regular-svg-icons';

import { Status, StatusState, StatusLabel } from '../../../../../../components/lib';
import { handleStopPropagation } from '../../../../../../utils';
import { getUIStatusData, StatusStateInfo } from '../../../../../../models/ui/runtimeDeploy/status';

const ErrorMark = (
   <>
      {' '}
      <FontAwesomeIcon icon={faExclamationTriangle} color={'var(--yc-color-text-danger)'} />
   </>
);

interface Props<T extends string | number> {
   state: T | null;
   statusMap: Record<T, StatusState>;
   statusStateInfo: StatusStateInfo;
   existMessage?: boolean;
   openMessage?(): void;
   existErrors: boolean;
   openError?(): void;
   inline?: boolean;
}

export function RuntimeStatus<T extends string | number>({
   state,
   statusMap,
   statusStateInfo,
   openMessage,
   existMessage,
   openError,
   existErrors,
   inline = false,
}: Props<T>) {
   const { statusState, message, clickable, showWarning } = getUIStatusData({
      state,
      statusStateInfo,
      existMessage,
      existErrors,
      statusMap,
   });

   const status = (
      <Status state={statusState}>
         {message}
         {!inline && showWarning && ErrorMark}
      </Status>
   );

   const openModal = useCallback(() => (existErrors ? openError?.() : openMessage?.()), [
      existErrors,
      openError,
      openMessage,
   ]);

   const showLabel = clickable && !inline;

   if (showLabel) {
      return (
         <div style={{ marginLeft: '-8px', display: 'inline-block' }}>
            <StatusLabel
               state={statusState}
               text={message}
               onClick={e => {
                  handleStopPropagation(e);
                  openModal?.();
               }}
            >
               {status}
            </StatusLabel>
         </div>
      );
   }

   return status;
}

RuntimeStatus.displayName = 'RuntimeStatus';
