import React from 'react';

import { YpError, YpErrorHeader } from '../../../../../../components';
import { getLevelWarningCount, WarningLevelData } from '../../../../../../models/ui';

import classes from './RuntimeWarning.module.css';

interface Props {
   title?: string;
   id?: string;
   level: WarningLevelData<string>;
}

export const RuntimeWarning: React.FC<Props> = ({ title, id, level, children }) => {
   const count = getLevelWarningCount(level);
   if (count === 0) {
      return null;
   }
   return (
      <div>
         {title && id && (
            <YpErrorHeader title={title} id={id} size={'s'} count={count}>
               {children}
            </YpErrorHeader>
         )}
         <div className={classes.error}>
            <YpError level={level} />
         </div>
      </div>
   );
};

RuntimeWarning.displayName = 'RuntimeWarning';
