import React from 'react';

import { Status, StatusState } from '../../../../../../components/lib';
import { ESchedulingState } from '../../../../../../proto-typings';

const statusMap: Record<ESchedulingState, StatusState> = {
   [ESchedulingState.SS_ASSIGNED]: StatusState.Ok,
   [ESchedulingState.SS_PENDING]: StatusState.Progress,
   [ESchedulingState.SS_DISABLED]: StatusState.Inactive,
   [ESchedulingState.SS_NONE]: StatusState.Unknown,
};

interface Props {
   state: ESchedulingState | null;
}

export const SchedulingStatus: React.FC<Props> = React.memo(({ state }) => (
   <Status state={state ? statusMap[state] : StatusState.Unknown}>
      {state ? String(state).replaceAll('_', ' ').toLocaleLowerCase() : 'unknown'}
   </Status>
));

SchedulingStatus.displayName = 'SchedulingStatus';
