import React from 'react';

import { RichMessage } from '../../../../../../components';
import { MiniBox } from '../../../../../../components/lib';

interface Props {
   text: string | null;
   title?: string;
   mode?: 'text' | 'block';
}

export const StageDescription: React.FC<Props> = ({ text, title = 'revision description', mode = 'text' }) => {
   if (!text) {
      return null;
   }
   return (
      <MiniBox width={'400px'} height={'300px'} showMoreTitle={'show more'} fullTextTitle={title} preferenceMode={mode}>
         <RichMessage text={text} />
      </MiniBox>
   );
};
