import React from 'react';

import { StageRequestKeys } from '../../../../../../models/ui';
import { useNetworkErrors, useStage } from '../../../../../../redux';
import { YpErrorTooltip } from '../../../../../../components/network';

import classes from './StageHeader.module.css';

interface Props {
   stageId: string;
}

export const StageHeader: React.FC<Props> = React.memo(({ stageId }) => {
   const { stage, stageStatus, rawStage } = useStage(stageId);

   const requestKey = StageRequestKeys.getOne({ id: stageId });
   const networkErrors = useNetworkErrors([requestKey]);

   if (!(stage && stageStatus && rawStage)) {
      return null;
   }

   const stageError = networkErrors[StageRequestKeys.getOne({ id: stageId })];

   return (
      <div className={classes.header}>
         {stageError?.error && (
            <div className={classes.error}>
               <YpErrorTooltip error={stageError.error} request={stageError.request} />
            </div>
         )}
      </div>
   );
});

StageHeader.displayName = 'StageHeader';
