import React from 'react';

import { HelpPopover } from '@yandex-cloud/uikit';
import { EMPTY_VALUE, ExternalLink, formatDate } from '@yandex-infracloud-ui/libs';

import { useStageStatusView } from '../../hooks';
import { DefinitionList } from '../../../../../../components/lib';

import { StageDescription } from '../StageDescription/StageDescription';
import { StageRevision } from '../StageRevision/StageRevision';
import { StageXRay } from '../StageXRay/StageXRay';
import { StageHealth } from '../StageHealth/StageHealth';

import classes from './StageInfoBlock.module.css';
import { EXTERNAL_LINKS } from '../../../../../../models';

interface Props {
   stageId: string;
}

export const StageInfoBlock: React.FC<Props> = React.memo(({ stageId }) => {
   const { stageStatusViewList } = useStageStatusView({ stageSelectData: [{ stageId }] });

   const [stageStatusView = null] = stageStatusViewList;

   const { revision: statusRevision, updateDate, spec } = stageStatusView ?? {};

   return (
      <main>
         <h1 className={classes.stageName}>{stageId}</h1>
         <br />
         <h2>Revision</h2>
         <br />
         <DefinitionList
            className={classes.revisionInfo}
            items={[
               {
                  name: 'Revision',
                  content: <StageRevision stageId={stageId} />,
               },
               {
                  name: 'Updated time',
                  content: <div>{updateDate && formatDate(updateDate)}</div>,
               },
               {
                  name: 'Description',
                  content: spec?.revisionDescription ? (
                     <StageDescription
                        mode={'block'}
                        text={spec.revisionDescription}
                        title={`Description for revision ${statusRevision} of stage ${stageId}`}
                     />
                  ) : (
                     <span>{EMPTY_VALUE}</span>
                  ),
               },
            ]}
         />
         <br />
         <h2>XRay</h2>
         <br />
         <StageXRay stageId={stageId} />
         <br />
         <h2>
            Health{' '}
            <HelpPopover
               content={
                  <>
                     See <ExternalLink href={EXTERNAL_LINKS.deployDocs.stageHealth}>documentation</ExternalLink>
                  </>
               }
            />
         </h2>
         <br />
         <StageHealth stageId={stageId} />
      </main>
   );
});
