import React from 'react';

import { classNames } from '@yandex-infracloud-ui/libs';

import { OrderList } from '../../../../../../components/lib';
import { StageStatusState } from '../../../../../../models/ui/stage/Stage/StageStatusConverter';
import { useStage } from '../../../../../../redux';

import classes from './StageRevision.module.css';

interface Props {
   stageId: string;
}

export const StageRevision: React.FC<Props> = React.memo(({ stageId }) => {
   const { stage, stageStatus, stageStatusLabel } = useStage(stageId);
   const { revision } = stage || {};
   const { revision: statusRevision } = stageStatus || {};

   if (!(stage && stageStatus && stageStatusLabel)) {
      return null;
   }
   const { state } = stageStatusLabel;
   const isInProgress = state === StageStatusState.InProgress;

   return (
      <div className={classes.revisionInfo}>
         <div className={classNames(classes.revision, isInProgress ? classes.progress : undefined)}>
            {isInProgress && statusRevision === revision && 'Target'}
            Rev &nbsp;
            <span data-test={'stage--revision'}>{statusRevision ?? 'N/A'}</span>
            {statusRevision !== revision && <OrderList items={[<span> </span>, revision]} />}
         </div>
      </div>
   );
});

StageRevision.displayName = 'StageRevision';
