import { Popover } from '@yandex-cloud/uikit';

import { Collapse } from '@yandex-data-ui/common';
import { Json } from '@yandex-infracloud-ui/libs';
import React from 'react';

import { Status, StatusLabel, StatusType } from '../../../../../../components/lib';
import { stageStatusesMap } from '../../../../../../models/ui';
import { useStageStatusView } from '../../hooks';

import classes from './StageStatusBadge.module.css';

interface Props {
   stageId: string;
   type?: StatusType;
}

/**
 * выводит статус стейджа, берёт данные из контекста
 */
export const StageStatusBadge: React.FC<Props> = React.memo(({ stageId, type }) => {
   const { stageStatusViewList } = useStageStatusView({ stageSelectData: [{ stageId }] });
   const [stageStatusView = null] = stageStatusViewList;

   if (!stageStatusView) {
      return null;
   }

   const { state, text, additional, calculate } = stageStatusView.mergeStageStatusLabel;
   const statusState = stageStatusesMap[state];

   const status = (
      <div data-test={'stage--badge'}>
         <Status state={statusState} type={type} className={classes.statusPlate}>
            {text}
         </Status>
      </div>
   );

   const showTooltip = additional || calculate;

   if (!showTooltip) {
      return status;
   }

   const calculateInfo = calculate && (
      <div>
         <strong>Raw status</strong>
         <br />
         <Status state={stageStatusesMap[stageStatusView.stageStatusLabel.state]}>
            {stageStatusView.stageStatusLabel.text}
         </Status>
         <Collapse title={<span>JSON</span>}>
            <Json obj={stageStatusView.stageStatusLabel} />
         </Collapse>
      </div>
   );

   const tooltipContent = (
      <div>
         {additional}
         {calculateInfo}
      </div>
   );

   const needLabel = type === StatusType.Secondary;
   const statusBlock = needLabel ? <StatusLabel state={statusState}>{status}</StatusLabel> : status;

   return (
      <Popover content={tooltipContent} placement={['bottom', 'auto']} openOnHover={false}>
         <div className={classes.label}>{statusBlock}</div>
      </Popover>
   );
});

StageStatusBadge.displayName = 'StageStatusBadge';
