import React from 'react';

import { Loader } from '@yandex-infracloud-ui/libs';

import { useStage } from '../../../../../../redux';
import { useStageStatusView } from '../../hooks';
import { StageStatusBadge } from '../StageStatusBadge/StageStatusBadge';
import { StatusType } from '../../../../../../components/lib';
import { StageRevision } from '../StageRevision/StageRevision';

import classes from './StageTab.module.css';

interface Props {
   stageId: string;
}

export const StageTab: React.FC<Props> = React.memo(({ stageId }) => {
   const { stage, stageStatus } = useStage(stageId);
   const { stageStatusViewList } = useStageStatusView({ stageSelectData: [{ stageId }] });
   const [stageStatusView = null] = stageStatusViewList;

   const stageName = (
      <strong className={classes.name} data-test={'stage--name'} title={stageId}>
         {stageId}
      </strong>
   );

   if (!stageStatus) {
      return (
         <div>
            {stageName}
            <div className={classes.creation}>
               Waiting creation
               <Loader inline={true} />
            </div>
         </div>
      );
   }

   if (!stage) {
      return (
         <div>
            {stageName}
            <div className={classes.creation}>No data</div>
         </div>
      );
   }

   if (!stageStatusView) {
      return null;
   }

   const { waitingForApproveDuCount } = stageStatusView;

   return (
      <div>
         {stageName}
         <div className={classes.info}>
            <div data-test={'status--badge'} className={classes.status}>
               <StageStatusBadge stageId={stageId} type={StatusType.Secondary} />
            </div>

            <StageRevision stageId={stageId} />
         </div>

         {/* подумать над апрувами */}
         {waitingForApproveDuCount > 0 && (
            <div className={classes.approve}>Waiting for approve {waitingForApproveDuCount} DU</div>
         )}
      </div>
   );
});

StageTab.displayName = 'StageTab';
