import { Meta } from '@storybook/react';
import React from 'react';
import { List } from '@yandex-cloud/uikit';

import { apiServicesContextDecorator, routerDecorator } from '../../../../../../stories';

import { StageRevisionXRayStatus } from './StageRevisionXRayStatus';
import { XRayStatusSummary } from '../../../../../../models/ui/stage/XRay';
import classes from './StageRevisionXRayStatus.module.css';

type XRayStatusItem = XRayStatusSummary & { description: string };

const isLoading: XRayStatusItem = {
   description: 'Is loading',
   issues: { low: 0, high: 0, medium: 0 },
   stageHealth: 'n/a',
   analysisStatus: 'started',
   summaryType: 'loading',
};
const isFailedXRayStatus: XRayStatusItem = {
   description: 'Failed',
   issues: { low: 0, high: 0, medium: 0 },
   stageHealth: 'n/a',
   analysisStatus: 'failed',
   summaryType: 'failed',
};
const hasLowWarnings: XRayStatusItem = {
   description: 'Has low warnings',
   issues: { low: 7, high: 0, medium: 0 },
   stageHealth: 'info',
   analysisStatus: 'done',
   summaryType: 'info',
};
const hasMediumWarnings: XRayStatusItem = {
   description: 'Has medium warnings',
   issues: { low: 7, high: 0, medium: 7 },
   stageHealth: 'warning',
   analysisStatus: 'done',
   summaryType: 'warning',
};
const hasCriticalWarnings: XRayStatusItem = {
   description: 'Has critical Warnings',
   issues: { low: 7, high: 7, medium: 7 },
   stageHealth: 'critical',
   analysisStatus: 'done',
   summaryType: 'critical',
};
const okXRayStatus: XRayStatusItem = {
   description: 'OK',
   issues: { low: 0, high: 0, medium: 0 },
   stageHealth: 'ok',
   analysisStatus: 'done',
   summaryType: 'ok',
};

export const Regular = () => (
   <>
      <List
         items={[isLoading, isFailedXRayStatus, hasLowWarnings, hasMediumWarnings, hasCriticalWarnings, okXRayStatus]}
         itemsHeight={items => items.length * 60}
         className={classes.listStoriesWrapper}
         renderItem={item => (
            <div>
               <h3>{item.description}</h3>
               <StageRevisionXRayStatus
                  xRayStatus={item as XRayStatusSummary}
                  href={
                     'https://xray.sec.yandex-team.ru/stage/200ok-service-test-stage/f8cc158-b61a9971-73cd89a8-386958af/2'
                  }
               />
            </div>
         )}
         itemHeight={60}
      />
   </>
);

export default {
   decorators: [routerDecorator, apiServicesContextDecorator],
   title: 'pages/stages/_stageId/status/components/StageRevision/StageXRayStatus',
} as Meta;
