import React from 'react';

import { useStage } from '../../../../../../redux';
import { EXTERNAL_LINKS } from '../../../../../../models';

import { StageRevisionXRayStatus } from './StageRevisionXRayStatus';
import { useXRayStatus } from '../../../../../../redux/hooks/useXRayStatus';

interface Props {
   stageId: string;
}

export const StageXRay: React.FC<Props> = React.memo(({ stageId }) => {
   const { stage, rawStage } = useStage(stageId);
   const { revision, id } = stage || {};
   const { uuid } = rawStage?.meta ?? {};

   const { xRayStatus } = useXRayStatus(stageId);

   if (!(id && uuid && revision)) {
      return null;
   }

   const xrayHref = EXTERNAL_LINKS.xRayAnalysis(id, uuid, revision);

   return <StageRevisionXRayStatus xRayStatus={xRayStatus} href={xrayHref} />;
});

StageXRay.displayName = 'StageRevision';
