import React from 'react';

import { StatusState } from '../../../../../../components/lib';
import { PodObjectName, PodStaticResource } from '../../../../../../models/ui';
import { EStaticResourceState } from '../../../../../../proto-typings';
import { PodObjectStatus } from '../PodObjectStatus/PodObjectStatus';

const statusMap: Record<EStaticResourceState, StatusState> = {
   [EStaticResourceState.EStaticResourceState_DOWNLOADING]: StatusState.Progress,
   [EStaticResourceState.EStaticResourceState_INVALID]: StatusState.Error,
   [EStaticResourceState.EStaticResourceState_IN_QUEUE]: StatusState.Progress,
   [EStaticResourceState.EStaticResourceState_READY]: StatusState.Ok,
   [EStaticResourceState.EStaticResourceState_REMOVED]: StatusState.Inactive,
   [EStaticResourceState.EStaticResourceState_REMOVING]: StatusState.Progress,
   [EStaticResourceState.EStaticResourceState_UNKNOWN]: StatusState.Unknown,
   [EStaticResourceState.EStaticResourceState_VERIFICATION_IN_QUEUE]: StatusState.Progress,
   [EStaticResourceState.EStaticResourceState_VERIFYING]: StatusState.Progress,
   [EStaticResourceState.EStaticResourceState_WAITING_FOR_RESOURCE_GANG_META_CONTAINER]: StatusState.Progress,
};

interface Props {
   resource: PodStaticResource;
   inline?: boolean;
}

export const StaticResourceStatus: React.FC<Props> = React.memo(({ resource, inline }) => (
   <PodObjectStatus
      type={PodObjectName.StaticResource}
      podObject={resource}
      state={resource.state}
      statusMap={statusMap}
      inline={inline ?? false}
   />
));

StaticResourceStatus.displayName = 'StaticResourceStatus';
