import React from 'react';

import { classNames } from '@yandex-infracloud-ui/libs';

import classes from './StatusTab.module.css';

interface Props {
   onSelect(): void;
   active?: boolean;
   key?: string;
   dataTest?: string;
   ariaLabel?: string;
}

export const StatusTab: React.FC<Props> = React.memo(({ onSelect, active, key, dataTest, ariaLabel, children }) => (
   <div
      key={key}
      data-test={dataTest}
      role={'button'}
      tabIndex={0}
      aria-label={ariaLabel}
      className={classNames(classes.tab, active ? classes.active : undefined)}
      onClick={onSelect}
   >
      {children}
   </div>
));
