import React from 'react';

import { StatusState } from '../../../../../../components/lib';
import { PodVolume } from '../../../../../../models/ui';
import { EVolumeState } from '../../../../../../proto-typings';
import { PodObjectStatus } from '../PodObjectStatus/PodObjectStatus';
import { PodObjectName } from '../../../../../../models/ui/runtimeDeploy';

const statusMap: Record<EVolumeState, StatusState> = {
   [EVolumeState.EVolumeState_CREATING]: StatusState.Progress,
   [EVolumeState.EVolumeState_INVALID]: StatusState.Error,
   [EVolumeState.EVolumeState_READY]: StatusState.Ok,
   [EVolumeState.EVolumeState_REMOVED]: StatusState.Inactive,
   [EVolumeState.EVolumeState_REMOVING]: StatusState.Progress,
   [EVolumeState.EVolumeState_UNKNOWN]: StatusState.Unknown,
   [EVolumeState.EVolumeState_WAITING_FOR_LAYERS]: StatusState.Progress,
   [EVolumeState.EVolumeState_WAITING_FOR_STATIC_RESOURCES]: StatusState.Progress,
};

interface Props {
   volume: PodVolume;
   inline?: boolean;
}

export const VolumeStatus: React.FC<Props> = React.memo(({ volume, inline }) => (
   <PodObjectStatus
      type={PodObjectName.Volume}
      podObject={volume}
      state={volume.state}
      statusMap={statusMap}
      inline={inline ?? false}
   />
));

VolumeStatus.displayName = 'VolumeStatus';
