import React from 'react';

import { StatusState } from '../../../../../../components/lib';
import { PodWorkload } from '../../../../../../models/ui';
import { EWorkloadState } from '../../../../../../proto-typings';
import { PodObjectStatus } from '../PodObjectStatus/PodObjectStatus';
import { PodObjectName } from '../../../../../../models/ui/runtimeDeploy';

const statusMap: Record<EWorkloadState, StatusState> = {
   [EWorkloadState.EWorkloadState_ACTIVATING]: StatusState.Progress,
   [EWorkloadState.EWorkloadState_ACTIVE]: StatusState.Ok,
   [EWorkloadState.EWorkloadState_DEACTIVATED_BY_LIVENESS]: StatusState.Error,
   [EWorkloadState.EWorkloadState_DEACTIVATING]: StatusState.Progress,
   [EWorkloadState.EWorkloadState_DEAD]: StatusState.Error,
   [EWorkloadState.EWorkloadState_FAILED_TO_START_LIVENESS]: StatusState.Error,
   [EWorkloadState.EWorkloadState_FAILED_TO_START_READINESS]: StatusState.Error,
   [EWorkloadState.EWorkloadState_INIT_PROCESSES]: StatusState.Progress,
   [EWorkloadState.EWorkloadState_INVALID]: StatusState.Error,
   [EWorkloadState.EWorkloadState_READINESS_FAILED]: StatusState.Error,
   [EWorkloadState.EWorkloadState_REMOVED]: StatusState.Inactive,
   [EWorkloadState.EWorkloadState_REMOVING]: StatusState.Progress,
   [EWorkloadState.EWorkloadState_UNKNOWN]: StatusState.Unknown,
   [EWorkloadState.EWorkloadState_WAITING_FOR_BOX]: StatusState.Progress,
};

interface Props {
   workload: PodWorkload;
   inline?: boolean;
}

export const WorkloadStatus: React.FC<Props> = React.memo(({ workload, inline }) => (
   <PodObjectStatus
      type={PodObjectName.Workload}
      podObject={workload}
      state={workload.state}
      statusMap={statusMap}
      inline={inline ?? false}
   />
));

WorkloadStatus.displayName = 'WorkloadStatus';
