import React from 'react';
import { PodStatusView, ReplicaSetStatusView } from '../../../../models/ui/status';
import { DeployUnitStatusView, StageStatusView } from '../../../../models/ui/status/stage/model';
import { StoreKeysMeta } from '../../../../utils';

export const ClusterContext = React.createContext<string | null>(null);

export type StatusViewStore = {
   pods: Record<string, PodStatusView> & StoreKeysMeta<'id' | 'location'>;
   replicaSets: Record<string, ReplicaSetStatusView> & StoreKeysMeta<'id' | 'location'>;
   deployUnits: Record<string, DeployUnitStatusView> & StoreKeysMeta<'stageId' | 'duId'>;
   stages: Record<string, StageStatusView> & StoreKeysMeta<'stageId'>;

   podKeysByReplicaSetKey: Record<string, string[]>;
};

export type UpdateStatusViewStore = (store: StatusViewStore) => StatusViewStore;
export type StatusViewStoreUpdater = (storeUpdate: UpdateStatusViewStore) => void;

export const getEmptyStatusViewStore: () => StatusViewStore = () => ({
   pods: {},
   replicaSets: {},
   deployUnits: {},
   stages: {},

   podKeysByReplicaSetKey: {},
});

export const StatusViewContext = React.createContext<StatusViewStore>(getEmptyStatusViewStore());
export const StatusViewUpdateContext = React.createContext<StatusViewStoreUpdater>(e => e);
