import { useContext, useMemo } from 'react';

import { DeployUnitStatusView } from '../../../../../models/ui/status';
import { createKey } from '../../../../../utils';
import { StatusViewContext } from '../context';

const filterDeployUnitStatusView = (view: DeployUnitStatusView | null): view is DeployUnitStatusView => view !== null;

export type DeployUnitSelectItem = {
   stageId: string;
   duId: string;
};

type UseDeployUnitStatusViewParams = {
   deployUnitSelectData: DeployUnitSelectItem[];
};

type UseDeployUnitStatusViewResult = {
   deployUnitStatusViewList: DeployUnitStatusView[];
   deployUnitStatusViewByKey: Record<string, DeployUnitStatusView | null>;
};

export function useDeployUnitStatusView({
   deployUnitSelectData,
}: UseDeployUnitStatusViewParams): UseDeployUnitStatusViewResult {
   const statusViewStore = useContext(StatusViewContext);

   const deployUnitStatusViewByKey: Record<string, DeployUnitStatusView | null> = useMemo(
      () =>
         Object.fromEntries(
            deployUnitSelectData.map(({ stageId, duId }) => {
               const duKey = createKey({ stageId, duId });
               return [duKey, statusViewStore.deployUnits[duKey] ?? null];
            }),
         ),
      [deployUnitSelectData, statusViewStore.deployUnits],
   );

   const deployUnitStatusViewList: DeployUnitStatusView[] = useMemo(
      () => Object.values(deployUnitStatusViewByKey).filter(filterDeployUnitStatusView),
      [deployUnitStatusViewByKey],
   );

   return { deployUnitStatusViewByKey, deployUnitStatusViewList };
}
