import { useContext, useMemo } from 'react';

import { PodStatusView } from '../../../../../models/ui/status';
import { createKey } from '../../../../../utils';
import { StatusViewContext } from '../context';

const filterPodStatusView = (view: PodStatusView | null): view is PodStatusView => view !== null;

export type PodSelectItem = {
   id: string;
   location: string;
};

export type UsePodsParams = {
   podSelectData: PodSelectItem[];
};

export type UsePodsResult = {
   podStatusViewList: PodStatusView[];
   podStatusViewByKey: Record<string, PodStatusView | null>;
};

export function usePodStatusView({ podSelectData }: UsePodsParams): UsePodsResult {
   const statusViewStore = useContext(StatusViewContext);

   const podStatusViewByKey: Record<string, PodStatusView | null> = useMemo(
      () =>
         Object.fromEntries(
            podSelectData.map(({ id, location }) => {
               const podKey = createKey({ id, location });
               return [podKey, statusViewStore.pods[podKey] ?? null];
            }),
         ),
      [podSelectData, statusViewStore.pods],
   );

   const podStatusViewList: PodStatusView[] = useMemo(
      () => Object.values(podStatusViewByKey).filter(filterPodStatusView),
      [podStatusViewByKey],
   );

   return { podStatusViewByKey, podStatusViewList };
}
