import { useContext, useMemo } from 'react';

import { ReplicaSetStatusView } from '../../../../../models/ui/status';
import { createKey } from '../../../../../utils';
import { StatusViewContext } from '../context';

const filterReplicaSetStatusView = (view: ReplicaSetStatusView | null): view is ReplicaSetStatusView => view !== null;

export type ReplicaSetSelectItem = {
   id: string;
   location: string;
};

type UseReplicaSetStatusViewParams = {
   replicaSetSelectData: ReplicaSetSelectItem[];
};

type UseReplicaSetStatusViewResult = {
   replicaSetStatusViewList: ReplicaSetStatusView[];
   replicaSetStatusViewByKey: Record<string, ReplicaSetStatusView | null>;
};

export function useReplicaSetStatusView({
   replicaSetSelectData,
}: UseReplicaSetStatusViewParams): UseReplicaSetStatusViewResult {
   const statusViewStore = useContext(StatusViewContext);

   const replicaSetStatusViewByKey: Record<string, ReplicaSetStatusView | null> = useMemo(
      () =>
         Object.fromEntries(
            replicaSetSelectData.map(({ id, location }) => {
               const replicaSetKey = createKey({ id, location });
               return [replicaSetKey, statusViewStore.replicaSets[replicaSetKey] ?? null];
            }),
         ),
      [replicaSetSelectData, statusViewStore.replicaSets],
   );

   const replicaSetStatusViewList: ReplicaSetStatusView[] = useMemo(
      () => Object.values(replicaSetStatusViewByKey).filter(filterReplicaSetStatusView),
      [replicaSetStatusViewByKey],
   );

   return { replicaSetStatusViewByKey, replicaSetStatusViewList };
}
