import { useContext, useMemo } from 'react';

import { StageStatusView } from '../../../../../models/ui/status';
import { createKey } from '../../../../../utils';
import { StatusViewContext } from '../context';

const filterStageStatusView = (view: StageStatusView | null): view is StageStatusView => view !== null;

export type StageSelectItem = {
   stageId: string;
};

type UseStageStatusViewParams = {
   stageSelectData: StageSelectItem[];
};

type UseStageStatusViewResult = {
   stageStatusViewList: StageStatusView[];
   stageStatusViewByKey: Record<string, StageStatusView | null>;
};

export function useStageStatusView({ stageSelectData }: UseStageStatusViewParams): UseStageStatusViewResult {
   const statusViewStore = useContext(StatusViewContext);

   const stageStatusViewByKey: Record<string, StageStatusView | null> = useMemo(
      () =>
         Object.fromEntries(
            stageSelectData.map(({ stageId }) => {
               const stageKey = createKey({ stageId });
               return [stageKey, statusViewStore.stages[stageKey] ?? null];
            }),
         ),
      [stageSelectData, statusViewStore.stages],
   );

   const stageStatusViewList: StageStatusView[] = useMemo(
      () => Object.values(stageStatusViewByKey).filter(filterStageStatusView),
      [stageStatusViewByKey],
   );

   return { stageStatusViewByKey, stageStatusViewList };
}
