import { useCallback, useEffect } from 'react';

import { TIMES_IN_MS, UpdateTimerMode, useUpdateTimer } from '@yandex-infracloud-ui/libs';
import { useDispatch } from 'react-redux';

import { fetchInfraDoctorInfo, useStage } from '../../../../../redux';

export function useUpdateStageProblems(stageId: string) {
   const { stage, rawStage } = useStage(stageId);
   const { revision } = stage || {};
   const { uuid } = rawStage?.meta ?? {};

   const dispatch = useDispatch();

   const updateProblems = useCallback(() => {
      if (uuid) {
         // запрашиваем только для текущего стейджа
         dispatch(fetchInfraDoctorInfo({ object_type: 'yp.stage', id: stageId, uuid }));
      }
   }, [dispatch, stageId, uuid]);

   useEffect(() => {
      updateProblems();
   }, [updateProblems, revision]);

   useUpdateTimer({
      callback: updateProblems,
      fast: TIMES_IN_MS.Minute,
      mode: UpdateTimerMode.Slow,
      slow: TIMES_IN_MS.Minute * 5,
   });
}
