import React from 'react';

import { faSpinner } from '@fortawesome/pro-regular-svg-icons';
import { FontAwesomeIcon } from '@fortawesome/react-fontawesome';
import { useTitle } from '@yandex-infracloud-ui/libs';
import { RouteComponentProps } from 'react-router';
import { Button } from '@yandex-cloud/uikit';

import { EditSharedNode } from '../../../../components/lib';
import { StageHugeForm } from '../../../../components/stage-huge-form';
import { StageHugeFormMode, StageHugeFormShowPage } from '../../../../components/stage-huge-form/models';
import { useFormStage } from '../../../../redux';

export const StageUpdatePage: React.FC<RouteComponentProps<{ stageId: string }>> = React.memo(({ location, match }) => {
   const { stageId } = match.params;
   const { rawStage } = useFormStage(StageHugeFormMode.Update, stageId);

   useTitle(`Updates / ${stageId}`);

   if (!rawStage) {
      return null;
   }

   return (
      <StageHugeForm mode={StageHugeFormMode.Update} rawStage={rawStage}>
         {form => (
            <>
               <EditSharedNode replace={true}>
                  {form.showPage === StageHugeFormShowPage.Diff && (
                     <Button onClick={form.cancel} extraProps={{ 'data-e2e': 'StageHugeForm:CancelButton' }}>
                        Edit
                     </Button>
                  )}

                  <Button
                     view={'action'}
                     onClick={form.update}
                     extraProps={{ 'data-e2e': 'StageHugeForm:UpdateButton' }}
                     disabled={
                        form.showPage === StageHugeFormShowPage.Diff ||
                        form.isSubmitting ||
                        !form.hasSelectedUpdateConfirmations
                     }
                  >
                     {form.isSubmitting ? (
                        <>
                           <FontAwesomeIcon icon={faSpinner} spin={true} /> Checking
                        </>
                     ) : (
                        'Review Changes'
                     )}
                  </Button>
               </EditSharedNode>

               {form.content}
            </>
         )}
      </StageHugeForm>
   );
});

StageUpdatePage.displayName = 'StageUpdatePage';
