import React from 'react';

import { ProductionClusters, TestClusters } from '../../models/ui/yp/view';
import { ClusterCard } from './__clusterCard/ClusterCard';

import classes from './Clusters.module.css';

export const Clusters: React.FC = () => (
   <div className={classes.page}>
      <div className={classes.title}>Production clusters</div>
      <div className={classes.cards}>
         {ProductionClusters.map(location => (
            <ClusterCard key={location} location={location} className={classes.card} />
         ))}
      </div>
      <div className={classes.title}>Testing clusters</div>
      <div className={classes.cards}>
         {TestClusters.map(location => (
            <ClusterCard key={location} location={location} className={classes.card} />
         ))}
      </div>
   </div>
);
