import React, { useMemo } from 'react';

import { classNames } from '@yandex-infracloud-ui/libs';
import { Link } from 'react-router-dom';

import { urlBuilder } from '../../../models';
import { YpLocation } from '../../../models/api';

import classes from './ClusterCard.module.css';

interface Props {
   location: YpLocation;
   className?: string;
}

export const ClusterCard: React.FC<Props> = ({ location, className }) => {
   const items = useMemo(
      () =>
         location !== YpLocation.XDC ? (
            [
               <Link to={urlBuilder.ypEntities(location, 'nodes')}>
                  <span className={classes.link}>Nodes</span>
               </Link>,
               <Link to={urlBuilder.ypEntities(location, 'pods')}>
                  <span className={classes.link}>Pods</span>
               </Link>,
               <Link to={urlBuilder.ypEntities(location, 'pod-sets')}>
                  <span className={classes.link}>Pod sets</span>
               </Link>,
               <Link to={urlBuilder.ypEntities(location, 'replica-sets')}>
                  <span className={classes.link}>Replica sets</span>
               </Link>,
            ]
         ) : (
            <Link to={urlBuilder.ypMulticlusterReplicaSets()}>
               <span className={classes.link}>Multicluster replica sets</span>
            </Link>
         ),
      [location],
   );

   return (
      <div className={classNames(classes.card, className)}>
         <div className={classes.title}>{location}</div>
         <div className={classes.links}>{items}</div>
      </div>
   );
};
