import React, { useEffect } from 'react';

import { YpLocation } from '../../../../../../models/api';
import { useYpNodeHistory } from '../../../../../../redux/hooks/useYpNodeHistory';
import { getHistoryRows } from './utils';
import { History } from '../../../../../../components/yp';
import { NodeHistoryEvent } from '../../../../../../models/ui/yp/view';

interface Props {
   nodeId?: string;
   uuid?: string;
   requestKey: string;
   cluster: YpLocation;
}

export const NodeHistory: React.FC<Props> = ({ nodeId, uuid, requestKey, cluster }) => {
   const { history, fetchNodeHistory, isFetching, canFetch } = useYpNodeHistory(nodeId, uuid, cluster, requestKey);

   useEffect(() => {
      fetchNodeHistory(true);
   }, []); // eslint-disable-line react-hooks/exhaustive-deps

   const rowData = getHistoryRows(history as NodeHistoryEvent[], cluster);

   return (
      <History
         columns={['State', 'Maintenance']}
         eventRows={rowData}
         canFetch={canFetch}
         isFetching={isFetching}
         onLoadMore={() => {
            fetchNodeHistory(false);
         }}
      />
   );
};

NodeHistory.displayName = 'Node__NodeHistory';
