import { fromQuery } from '@yandex-infracloud-ui/libs';
import { toArray } from '../../utils';

export const parseFiltersValuesFromSearch = (search: string) => {
   const queryValues = fromQuery(search, { arrayFormat: 'comma' });
   const { nodeId, state, maintenance, segments, query } = queryValues;

   return {
      nodeId,
      query,
      state: toArray(state),
      maintenance: toArray(maintenance),
      segments: toArray(segments),
   };
};
