import React from 'react';

import { DefinitionList, DefinitionListItem } from '../../../../../../../components/lib';
import { InfoGroup } from '../../../../../../../components/yp';
import { TAntiaffinityConstraint } from '../../../../../../../proto-typings';

interface Props {
   antiaffinity: TAntiaffinityConstraint[];
}

export const AntiaffinityConstraints: React.FC<Props> = ({ antiaffinity }) => (
   <InfoGroup title={'Antiaffinity constraints'}>
      {antiaffinity.map(({ key, max_pods, pod_group_id_path }) => {
         const items: DefinitionListItem[] = [
            {
               name: 'Key',
               content: key,
            },
            {
               name: 'Max pods',
               content: max_pods,
            },
            {
               name: 'Pod group ID path',
               content: pod_group_id_path,
               copyText: true,
            },
         ];

         return (
            <InfoGroup>
               <DefinitionList items={items} />
            </InfoGroup>
         );
      })}
   </InfoGroup>
);

AntiaffinityConstraints.displayName = 'AntiaffinityConstraints';
