import React from 'react';

import { DefinitionList, DefinitionListItem } from '../../../../../../components/lib';
import { TPodSet } from '../../../../../../proto-typings';
import { FormatDate } from '../../../../../../components/yp/FormatDate/FormatDate';
import { AntiaffinityConstraints } from '../../components/AntiaffinityConstraints';
import { InfoGroup } from '../../../../../../components/yp';
import { getPodSetService } from '../../../../../../utils/yp';
import { DeployEngine } from '../../../../../../models/ui/yp/view';

import classes from './PodSetInfo.module.css';

interface Props {
   podSet: TPodSet;
   cluster: string;
}

export const PodSetInfo: React.FC<Props> = ({ podSet, cluster }) => {
   const { meta, labels = {}, spec } = podSet;
   const deployEngine = labels.deploy_engine;
   const { serviceId, serviceLink } = getPodSetService(podSet, cluster);

   const fields: DefinitionListItem[] = [
      {
         name: 'ID',
         content: podSet.meta?.id,
         copyText: true,
      },
      {
         name: 'Deploy engine',
         content: deployEngine === DeployEngine.YPLite ? 'YP Lite' : `Deploy/${deployEngine}`,
      },
      {
         name: 'Service',
         content: serviceLink,
         copyText: serviceId,
      },
      {
         name: 'Creation time',
         content: <FormatDate timestamp={meta?.creation_time} empty={'Unknown'} />,
      },
      {
         name: 'Account ID',
         content: podSet.meta?.account_id,
         copyText: true,
      },
      {
         name: 'Node segment',
         content: spec?.node_segment_id,
         copyText: true,
      },
      {
         name: 'Node filter',
         content: spec?.node_filter,
         copyText: true,
      },
   ];

   const antiaffinity = spec?.antiaffinity_constraints;
   const antiaffinityContent = antiaffinity && <AntiaffinityConstraints constraints={antiaffinity} />;

   return (
      <div className={classes.container}>
         <InfoGroup>
            <DefinitionList items={fields} />
         </InfoGroup>
         {antiaffinityContent}
      </div>
   );
};

PodSetInfo.displayName = 'PodSetInfo';
