import { Button, Loader } from '@yandex-cloud/uikit';
import React, { useState } from 'react';
import { PodsTable } from '../../../../../../components/yp';
import { YpLocation } from '../../../../../../models/api';
import { TPod } from '../../../../../../proto-typings';
import classes from './PodSetPods.module.css';

interface Props {
   pods: TPod[];
   canFetch: boolean;
   isFetching: boolean;
   onLoadMore(newPage: number): void;
   cluster: YpLocation;
}

export const PodSetPods: React.FC<Props> = ({ pods, canFetch, isFetching, onLoadMore, cluster }) => {
   const [page, setPage] = useState(1);

   return (
      <div>
         <PodsTable cluster={cluster} pods={pods} emptyText={isFetching ? 'Loading pods...' : undefined} />
         <div className={classes.loaderContainer}>
            {isFetching && <Loader size={'s'} />}
            {canFetch && !isFetching && (
               <Button
                  onClick={() => {
                     onLoadMore(page + 1);
                     setPage(page + 1);
                  }}
                  view={'outlined'}
               >
                  Load more
               </Button>
            )}
         </div>
      </div>
   );
};
