import React from 'react';

import { DefinitionList, DefinitionListItem } from '../../../../../components/lib';
import { TAntiaffinityConstraint } from '../../../../../proto-typings';

import classes from './AntiaffinityConstraints.module.css';

interface Props {
   constraints: TAntiaffinityConstraint[];
}

export const AntiaffinityConstraints: React.FC<Props> = ({ constraints }) => {
   const constraintsLists = constraints.map(({ key, max_pods, pod_group_id_path }) => {
      const defListItems: DefinitionListItem[] = [
         {
            name: 'Key',
            content: key,
         },
         {
            name: 'Max pods',
            content: max_pods,
         },
         {
            name: 'Path',
            content: pod_group_id_path,
            copyText: true,
         },
      ];

      return <DefinitionList className={classes.constraintsList} items={defListItems} key={key} />;
   });

   return <div className={classes.constraints}>{constraintsLists}</div>;
};
