import { fromQuery } from '@yandex-infracloud-ui/libs';

import { DeployEngine, PodSetsFiltersParams } from '../../../../models/ui/yp/view';
import { toArray } from '../../utils';

export const parseFiltersValuesFromSearch = (search: string): PodSetsFiltersParams => {
   const queryValues = fromQuery(search, { arrayFormat: 'comma' });
   const { podSetId, segments, accountId, query, serviceId, deployEngine } = queryValues;

   return {
      podSetId: podSetId ? podSetId.toString() : undefined,
      query: query ? query.toString() : undefined,
      serviceId: serviceId ? serviceId.toString() : undefined,
      segments: toArray(segments),
      accountId: accountId ? accountId.toString() : undefined,
      deployEngine: toArray(deployEngine) as DeployEngine[],
   };
};
