import React, { useEffect } from 'react';
import { YpLocation } from '../../../../../../models/api';
import { useYpPodHistory } from '../../../../../../redux';
import { getHistoryRows } from './utils';
import { History } from '../../../../../../components/yp';

// FIXME: сделать нормальный корень для models/ui/yp/view
import { PodHistoryEvent } from '../../../../../../models/ui/yp/view';

interface Props {
   podId: string;
   uuid?: string;
   requestKey: string;
   cluster: YpLocation;
}

export const PodHistory: React.FC<Props> = ({ podId, uuid, requestKey, cluster }) => {
   const { history, fetchPodHistory, isFetching, canFetch } = useYpPodHistory(podId, uuid, cluster, requestKey);

   useEffect(() => {
      fetchPodHistory(true);
   }, []); // eslint-disable-line react-hooks/exhaustive-deps

   const rowData = getHistoryRows(history as PodHistoryEvent[], cluster);

   return (
      <History
         columns={['Eviction', 'Maintenance', 'Scheduling']}
         eventRows={rowData}
         canFetch={canFetch}
         isFetching={isFetching}
         onLoadMore={() => {
            fetchPodHistory(false);
         }}
      />
   );
};

PodHistory.displayName = 'Pod__PodHistory';
