import { fromQuery } from '@yandex-infracloud-ui/libs';
import { EEvictionState, EPodCurrentState, ESchedulingState } from '../../../../proto-typings';
import { PodsFiltersParams } from './models';

const toArray = (value?: null | string | (string | null)[]) => {
   if (!value) {
      return [];
   }

   if (Array.isArray(value)) {
      return value.filter((item): item is string => Boolean(item));
   }

   return [value];
};

export const parseFiltersValuesFromSearch = (search: string): PodsFiltersParams => {
   const queryValues = fromQuery(search, { arrayFormat: 'comma' });
   const { podId, podSetId, service, podState, evictionState, schedulingState, query } = queryValues;

   return {
      podId: podId as string,
      podSetId: podSetId as string,
      service: service as string,
      podState: toArray(podState) as EPodCurrentState[],
      evictionState: toArray(evictionState) as EEvictionState[],
      schedulingState: toArray(schedulingState) as ESchedulingState[],
      query: query as string,
   };
};
