import { AppRouteProps } from '../../models';
import { Nodes } from './_cluster/nodes/Nodes';
import { Clusters } from './Clusters';
import { Node } from './_cluster/nodes/_entityId/Node';
import { Pod } from './_cluster/pods/_entityId/Pod';
import { Pods } from './_cluster/pods/Pods';
import { PodSets } from './_cluster/pod-sets/PodSets';
import { PodSet } from './_cluster/pod-sets/_entityId/PodSet';
import { ReplicaSets } from './_cluster/replica-sets/ReplicaSets';
import { ReplicaSet } from './_cluster/replica-sets/_entityId/ReplicaSet';
import { MulticlusterReplicaSets } from './_cluster/multicluster-replica-sets/MulticlusterReplicaSets';
import { MulticlusterReplicaSet } from './_cluster/multicluster-replica-sets/_entityId/MulticlusterReplicaSet';

export const ROUTES: AppRouteProps[] = [
   { path: '/:cluster/nodes/:entityId', component: Node },
   { path: '/:cluster/nodes', component: Nodes },
   { path: '/:cluster/pods/:entityId', component: Pod },
   { path: '/:cluster/pods', component: Pods },
   { path: '/:cluster/pod-sets/:entityId', component: PodSet },
   { path: '/:cluster/pod-sets', component: PodSets },
   { path: '/:cluster/replica-sets/:entityId', component: ReplicaSet },
   { path: '/:cluster/replica-sets', component: ReplicaSets },
   { path: '/xdc/multicluster-replica-sets/:entityId', component: MulticlusterReplicaSet },
   { path: '/xdc/multicluster-replica-sets', component: MulticlusterReplicaSets },
   { path: '/', component: Clusters, exact: true },
];
