import { fromQuery } from '@yandex-infracloud-ui/libs';
import React, { ReactNode } from 'react';
import { YpErrorTooltip } from '../../components/network';
import { urlBuilder, YPEntityTypes } from '../../models';
import { ReplicaSetFiltersParams, ReplicaSetState } from '../../models/ui/yp/models';
import { Breadcrumbs, BreadcrumbLink } from '../../old-code/components/Breadcrumbs/Breadcrumbs';
import { NetworkItem } from '../../redux/slices/network/model';

export type Navigation = React.FunctionComponentElement<React.ComponentProps<typeof Breadcrumbs>>;

interface YPRouteEntity {
   id: YPEntityTypes;
   title: string;
}

export function getNavigation(cluster: string, entityType: YPEntityTypes | YPRouteEntity, entityId: string): Navigation;
export function getNavigation(
   cluster: string,
   entityType: YPEntityTypes | YPRouteEntity,
   entityId?: string,
): Navigation;
export function getNavigation(
   cluster: string,
   entityType?: YPEntityTypes | YPRouteEntity,
   entityId?: string,
): Navigation {
   const items: BreadcrumbLink[] = [{ name: 'YP', url: urlBuilder.yp() }];

   if (cluster) {
      items.push({ name: cluster });
   }

   if (entityType) {
      if (typeof entityType === 'string') {
         items.push({ name: entityType, url: entityId ? urlBuilder.ypEntities(cluster, entityType) : undefined });
      } else {
         items.push({
            name: entityType.title,
            url: entityId ? urlBuilder.ypEntities(cluster, entityType.id) : undefined,
         });
      }
   }

   if (entityId) {
      items.push({ name: entityId });
   }

   return React.createElement(Breadcrumbs, { links: items });
}

export const toArray = (value?: null | string | (string | null)[]): string[] | undefined => {
   if (!value) {
      return undefined;
   }

   if (Array.isArray(value)) {
      return value.filter((item): item is string => Boolean(item));
   }

   return [value];
};

export const getYPError = (error: Partial<NetworkItem> | null, className?: string): ReactNode =>
   error?.error && <YpErrorTooltip error={error.error} request={error.request} className={className} />;

const getStringValue = (queryValue: (string | null)[] | string | null) => {
   if (queryValue === null) {
      return undefined;
   }

   if (Array.isArray(queryValue)) {
      return queryValue.filter(Boolean).join(', ');
   }

   return queryValue;
};

export const parseFiltersValuesFromSearch = (search: string): ReplicaSetFiltersParams => {
   const queryValues = fromQuery(search, { arrayFormat: 'comma' });
   const { replicaSetId, stageId, state, revision, query } = queryValues;

   const result: ReplicaSetFiltersParams = {
      replicaSetId: getStringValue(replicaSetId),
      stageId: getStringValue(stageId),
      revision: getStringValue(revision),
   };

   if (state !== null) {
      const newState = (Array.isArray(state) ? state : [state]).filter(Boolean) as ReplicaSetState[];
      result.state = newState.length ? newState : undefined;
   }

   if (query !== null) {
      result.query = Array.isArray(query) ? query.join(' ') : query;
   }

   return result;
};
