/* eslint-disable */

export enum EAccessControlAction {
   ACA_ALLOW = 'allow',
   ACA_DENY = 'deny',
}

export enum EAccessControlPermission {
   ACP_NONE = 'none',
   ACP_READ = 'read',
   ACP_READ_SECRETS = 'read_secrets',
   ACA_WRITE = 'write',
   ACA_CREATE = 'create',
   ACA_SSH_ACCESS = 'ssh_access',
   ACA_ROOT_SSH_ACCESS = 'root_ssh_access',
   ACA_USE = 'use',
   ACA_GET_QYP_VM_STATUS = 'get_qyp_vm_status',
}

export interface TAccessControlEntry {
   /**
    *  Determines the access control action to take upon a match.
    */
   action: EAccessControlAction;
   /**
    *  List of permissions this entry applies to.
    */
   permissions: EAccessControlPermission[];
   /**
    *  List of subjects (users and groups) this entry applies to.
    */
   subjects: string[];
   /**
    *  List of attribute paths this entry applies to.
    *  If this list is not specified or empty, this entry is applied to the root attribute path.
    */
   attributes: string[];
}
