/* eslint-disable */

/**
 *  for field descriptions see NYP.NClient.NApi.NProto.TApprovalPolicyMeta
 */
export interface TApprovalPolicyMetaBase {
   /**
    *  Id of parent stage.
    */
   stage_id: string;
}

export interface TApprovalPolicySpec {
   /**
    *  For REQUIRED all tickets must be approved,
    *  for OPTIONAL it is possible commit tickets without approval.
    *  NONE is equivalent to OPTIONAL.
    */
   mode: TApprovalPolicySpec_EMode;
   multiple_approval: TMultipleApproval | undefined;
   mandatory_multiple_approval: TMandatoryMultipleApproval | undefined;
   exclusions: TApprovalPolicySpec_TExclusion[];
}

export enum TApprovalPolicySpec_EMode {
   NONE = 'none',
   OPTIONAL = 'optional',
   REQUIRED = 'required',
}

export interface TApprovalPolicySpec_TExclusion {
   type: TApprovalPolicySpec_TExclusion_EType;
   release_rule: TApprovalPolicySpec_TExclusion_TReleaseRuleExclusion | undefined;
   compute_resources: TApprovalPolicySpec_TExclusion_TComputeResourcesExclusion | undefined;
   environment_variable: TApprovalPolicySpec_TExclusion_TEnvironmentVariableExclusion | undefined;
}

export enum TApprovalPolicySpec_TExclusion_EType {
   NONE = 'none',
   RELEASE_RULE = 'release_rule',
   COMPUTE_RESOURCES = 'compute_resources',
   ENVIRONMENT_VARIABLE = 'environment_variable',
}

export interface TApprovalPolicySpec_TExclusion_TReleaseRuleExclusion {
   release_rule_id: string;
}

export interface TApprovalPolicySpec_TExclusion_TComputeResourcesExclusion {}

export interface TApprovalPolicySpec_TExclusion_TEnvironmentVariableExclusion {
   name: string;
}

export interface TMultipleApproval {
   /**
    *  Minimum number of approvals to commit ticket.
    */
   approvals_count: number;
}

/**
 *  At least one of approvers must have mandatory_approvals permission.
 */
export interface TMandatoryMultipleApproval {
   /**
    *  Minimum number of approvals to commit ticket.
    */
   approvals_count: number;
}

export interface TApprovalPolicyStatus {}
