/* eslint-disable */
import { TAccessControlEntry } from '../../../../../yp_proto/yp/client/api/proto/access_control';
import {
   TNodeSpec,
   TNodeStatus,
   TNodeControl,
   TSchemaSpec,
   TSchemaStatus,
   TResourceSpec,
   TResourceStatus,
   TResourceControl,
   TPodSpec,
   TPodStatus,
   TPodControl,
   TPodSetSpec,
   TPodSetStatus,
   TEndpointSpec,
   TEndpointStatus,
   TEndpointSetSpec,
   TEndpointSetStatus,
   TNetworkProjectSpec,
   TNetworkProjectStatus,
   TNodeSegmentSpec,
   TNodeSegmentStatus,
   TVirtualServiceSpec,
   TVirtualServiceStatus,
   TUserSpec,
   TUserStatus,
   TGroupSpec,
   TGroupStatus,
   TInternetAddressSpec,
   TInternetAddressStatus,
   TIP4AddressPoolSpec,
   TIP4AddressPoolStatus,
   TDnsRecordSetSpec,
   TDnsRecordSetStatus,
   TAccountSpec,
   TAccountStatus,
   TPodDisruptionBudgetSpec,
   TPodDisruptionBudgetStatus,
   TMaintenanceSpec,
   TMaintenanceStatus,
   TWatchLogConsumerSpec,
   TWatchLogConsumerStatus,
} from '../../../../../yp_proto/yp/client/api/proto/data_model';
import { TAttributeDictionary } from '../../../../../yt_proto/yt/core/ytree/proto/attributes';
import {
   TAddDeployChild,
   TRemoveDeployChild,
   TAddSecretDelegation,
   TRemoveSecretDelegation,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_control';
import { EResourceKind, EPersistentDiskKind } from '../../../../../yp_proto/yp/client/api/proto/enums';
import {
   TApprovalPolicySpec,
   TApprovalPolicyStatus,
} from '../../../../../yp_proto/yp/client/api/proto/approval_policy';
import { TDaemonSetSpec, TDaemonSetStatus } from '../../../../../yp_proto/yp/client/api/proto/daemon_set';
import {
   TDeployTicketSpec,
   TDeployTicketStatus,
   TDeployTicketControl,
} from '../../../../../yp_proto/yp/client/api/proto/deploy_ticket';
import { TDnsZoneSpec, TDnsZoneStatus } from '../../../../../yp_proto/yp/client/api/proto/dns_zone';
import {
   TDynamicResourceSpec,
   TDynamicResourceStatus,
} from '../../../../../yp_proto/yp/client/api/proto/dynamic_resource';
import {
   THorizontalPodAutoscalerSpec,
   THorizontalPodAutoscalerStatus,
} from '../../../../../yp_proto/yp/client/api/proto/horizontal_pod_autoscaler';
import {
   TMultiClusterReplicaSetSpec,
   TMultiClusterReplicaSetStatus,
} from '../../../../../yp_proto/yp/client/api/proto/multi_cluster_replica_set';
import { TNannyServiceSpec, TNannyServiceStatus } from '../../../../../yp_proto/yp/client/api/proto/nanny_service';
import {
   TNotificationInfoSpec,
   TNotificationInfoStatus,
} from '../../../../../yp_proto/yp/client/api/proto/notification_info';
import {
   TNotificationPolicySpec,
   TNotificationPolicyStatus,
} from '../../../../../yp_proto/yp/client/api/proto/notification_policy';
import {
   TPersistentDiskSpec,
   TPersistentDiskStatus,
} from '../../../../../yp_proto/yp/client/api/proto/persistent_disk';
import {
   TPersistentVolumeClaimSpec,
   TPersistentVolumeClaimStatus,
} from '../../../../../yp_proto/yp/client/api/proto/persistent_volume_claim';
import {
   TPersistentVolumeSpec,
   TPersistentVolumeStatus,
} from '../../../../../yp_proto/yp/client/api/proto/persistent_volume';
import { TProjectSpec, TProjectStatus } from '../../../../../yp_proto/yp/client/api/proto/project';
import { ERelationKind, TRelationSpec, TRelationStatus } from '../../../../../yp_proto/yp/client/api/proto/relation';
import { TReleaseSpec, TReleaseStatus } from '../../../../../yp_proto/yp/client/api/proto/release';
import { TReleaseRuleSpec, TReleaseRuleStatus } from '../../../../../yp_proto/yp/client/api/proto/release_rule';
import { TReplicaSetSpec, TReplicaSetStatus } from '../../../../../yp_proto/yp/client/api/proto/replica_set';
import { TResourceCacheSpec, TResourceCacheStatus } from '../../../../../yp_proto/yp/client/api/proto/resource_cache';
import { TSecretSpec, TSecretStatus } from '../../../../../yp_proto/yp/client/api/proto/secret';
import {
   TSemaphoreAcquire,
   TSemaphorePing,
   TSemaphoreRelease,
   TSemaphoreSpec,
   TSemaphoreStatus,
} from '../../../../../yp_proto/yp/client/api/proto/semaphore';
import {
   TSemaphoreSetAcquire,
   TSemaphoreSetPing,
   TSemaphoreSetRelease,
   TSemaphoreSetSpec,
   TSemaphoreSetStatus,
} from '../../../../../yp_proto/yp/client/api/proto/semaphore_set';
import { TStageDraftSpec, TStageDraftStatus } from '../../../../../yp_proto/yp/client/api/proto/stage_draft';
import { TStageSpec, TStageStatus, TStageControl } from '../../../../../yp_proto/yp/client/api/proto/stage';
import {
   TSystemServiceConfigSpec,
   TSystemServiceConfigStatus,
} from '../../../../../yp_proto/yp/client/api/proto/system_service_config';

export enum EObjectType {
   OT_NODE = 'node',
   OT_SCHEMA = 'schema',
   OT_RESOURCE = 'resource',
   OT_POD = 'pod',
   OT_POD_SET = 'pod_set',
   OT_ENDPOINT = 'endpoint',
   OT_ENDPOINT_SET = 'endpoint_set',
   OT_NETWORK_PROJECT = 'network_project',
   OT_NODE_SEGMENT = 'node_segment',
   OT_VIRTUAL_SERVICE = 'virtual_service',
   OT_USER = 'user',
   OT_GROUP = 'group',
   OT_INTERNET_ADDRESS = 'internet_address',
   OT_IP4_ADDRESS_POOL = 'ip4_address_pool',
   OT_DNS_RECORD_SET = 'dns_record_set',
   OT_ACCOUNT = 'account',
   OT_POD_DISRUPTION_BUDGET = 'pod_disruption_budget',
   OT_MAINTENANCE = 'maintenance',
   OT_WATCH_LOG_CONSUMER = 'watch_log_consumer',
   OT_APPROVAL_POLICY = 'approval_policy',
   OT_DAEMON_SET = 'daemon_set',
   OT_DEPLOY_TICKET = 'deploy_ticket',
   OT_DNS_ZONE = 'dns_zone',
   OT_DYNAMIC_RESOURCE = 'dynamic_resource',
   OT_HORIZONTAL_POD_AUTOSCALER = 'horizontal_pod_autoscaler',
   OT_MULTI_CLUSTER_REPLICA_SET = 'multi_cluster_replica_set',
   OT_NANNY_SERVICE = 'nanny_service',
   OT_NOTIFICATION_INFO = 'notification_info',
   OT_NOTIFICATION_POLICY = 'notification_policy',
   OT_PERSISTENT_DISK = 'persistent_disk',
   OT_PERSISTENT_VOLUME_CLAIM = 'persistent_volume_claim',
   OT_PERSISTENT_VOLUME = 'persistent_volume',
   OT_PROJECT = 'project',
   OT_RELATION = 'relation',
   OT_RELEASE = 'release',
   OT_RELEASE_RULE = 'release_rule',
   OT_REPLICA_SET = 'replica_set',
   OT_RESOURCE_CACHE = 'resource_cache',
   OT_SECRET = 'secret',
   OT_SEMAPHORE = 'semaphore',
   OT_SEMAPHORE_SET = 'semaphore_set',
   OT_STAGE_DRAFT = 'stage_draft',
   OT_STAGE = 'stage',
   OT_SYSTEM_SERVICE_CONFIG = 'system_service_config',
   OT_NULL = 'null',
   OT_NODE2 = 'node2',
}

export interface TNodeMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TNode {
   meta: TNodeMeta | undefined;
   spec: TNodeSpec | undefined;
   status: TNodeStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNodeControl | undefined;
}

export interface TSchemaMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TSchemaControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TSchema {
   meta: TSchemaMeta | undefined;
   spec: TSchemaSpec | undefined;
   status: TSchemaStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TSchemaControl | undefined;
}

export interface TResourceMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   node_id: string;
   kind: EResourceKind;
}

export interface TResource {
   meta: TResourceMeta | undefined;
   spec: TResourceSpec | undefined;
   status: TResourceStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TResourceControl | undefined;
}

export interface TPodMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   pod_set_id: string;
}

export interface TPod {
   meta: TPodMeta | undefined;
   spec: TPodSpec | undefined;
   status: TPodStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPodControl | undefined;
}

export interface TPodSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TPodSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TPodSet {
   meta: TPodSetMeta | undefined;
   spec: TPodSetSpec | undefined;
   status: TPodSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPodSetControl | undefined;
}

export interface TEndpointMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   endpoint_set_id: string;
}

export interface TEndpointControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TEndpoint {
   meta: TEndpointMeta | undefined;
   spec: TEndpointSpec | undefined;
   status: TEndpointStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TEndpointControl | undefined;
}

export interface TEndpointSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TEndpointSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TEndpointSet {
   meta: TEndpointSetMeta | undefined;
   spec: TEndpointSetSpec | undefined;
   status: TEndpointSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TEndpointSetControl | undefined;
}

export interface TNetworkProjectMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TNetworkProjectControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TNetworkProject {
   meta: TNetworkProjectMeta | undefined;
   spec: TNetworkProjectSpec | undefined;
   status: TNetworkProjectStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNetworkProjectControl | undefined;
}

export interface TNodeSegmentMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TNodeSegmentControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TNodeSegment {
   meta: TNodeSegmentMeta | undefined;
   spec: TNodeSegmentSpec | undefined;
   status: TNodeSegmentStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNodeSegmentControl | undefined;
}

export interface TVirtualServiceMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TVirtualServiceControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TVirtualService {
   meta: TVirtualServiceMeta | undefined;
   spec: TVirtualServiceSpec | undefined;
   status: TVirtualServiceStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TVirtualServiceControl | undefined;
}

export interface TUserMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TUserControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TUser {
   meta: TUserMeta | undefined;
   spec: TUserSpec | undefined;
   status: TUserStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TUserControl | undefined;
}

export interface TGroupMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TGroupControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TGroup {
   meta: TGroupMeta | undefined;
   spec: TGroupSpec | undefined;
   status: TGroupStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TGroupControl | undefined;
}

export interface TInternetAddressMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   ip4_address_pool_id: string;
}

export interface TInternetAddressControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TInternetAddress {
   meta: TInternetAddressMeta | undefined;
   spec: TInternetAddressSpec | undefined;
   status: TInternetAddressStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TInternetAddressControl | undefined;
}

export interface TIP4AddressPoolMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TIP4AddressPoolControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TIP4AddressPool {
   meta: TIP4AddressPoolMeta | undefined;
   spec: TIP4AddressPoolSpec | undefined;
   status: TIP4AddressPoolStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TIP4AddressPoolControl | undefined;
}

export interface TDnsRecordSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TDnsRecordSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TDnsRecordSet {
   meta: TDnsRecordSetMeta | undefined;
   spec: TDnsRecordSetSpec | undefined;
   status: TDnsRecordSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TDnsRecordSetControl | undefined;
}

export interface TAccountMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TAccountControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TAccount {
   meta: TAccountMeta | undefined;
   spec: TAccountSpec | undefined;
   status: TAccountStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TAccountControl | undefined;
}

export interface TPodDisruptionBudgetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TPodDisruptionBudgetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TPodDisruptionBudget {
   meta: TPodDisruptionBudgetMeta | undefined;
   spec: TPodDisruptionBudgetSpec | undefined;
   status: TPodDisruptionBudgetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPodDisruptionBudgetControl | undefined;
}

export interface TMaintenanceMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TMaintenanceControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TMaintenance {
   meta: TMaintenanceMeta | undefined;
   spec: TMaintenanceSpec | undefined;
   status: TMaintenanceStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TMaintenanceControl | undefined;
}

export interface TWatchLogConsumerMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TWatchLogConsumerControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TWatchLogConsumer {
   meta: TWatchLogConsumerMeta | undefined;
   spec: TWatchLogConsumerSpec | undefined;
   status: TWatchLogConsumerStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TWatchLogConsumerControl | undefined;
}

export interface TApprovalPolicyMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TApprovalPolicyControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TApprovalPolicy {
   meta: TApprovalPolicyMeta | undefined;
   spec: TApprovalPolicySpec | undefined;
   status: TApprovalPolicyStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TApprovalPolicyControl | undefined;
}

export interface TDaemonSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   pod_set_id: string;
}

export interface TDaemonSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TDaemonSet {
   meta: TDaemonSetMeta | undefined;
   spec: TDaemonSetSpec | undefined;
   status: TDaemonSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TDaemonSetControl | undefined;
}

export interface TDeployTicketMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TDeployTicket {
   meta: TDeployTicketMeta | undefined;
   spec: TDeployTicketSpec | undefined;
   status: TDeployTicketStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TDeployTicketControl | undefined;
}

export interface TDnsZoneMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TDnsZoneControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TDnsZone {
   meta: TDnsZoneMeta | undefined;
   spec: TDnsZoneSpec | undefined;
   status: TDnsZoneStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TDnsZoneControl | undefined;
}

export interface TDynamicResourceMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   pod_set_id: string;
}

export interface TDynamicResourceControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TDynamicResource {
   meta: TDynamicResourceMeta | undefined;
   spec: TDynamicResourceSpec | undefined;
   status: TDynamicResourceStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TDynamicResourceControl | undefined;
}

export interface THorizontalPodAutoscalerMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   replica_set_id: string;
}

export interface THorizontalPodAutoscalerControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface THorizontalPodAutoscaler {
   meta: THorizontalPodAutoscalerMeta | undefined;
   spec: THorizontalPodAutoscalerSpec | undefined;
   status: THorizontalPodAutoscalerStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: THorizontalPodAutoscalerControl | undefined;
}

export interface TMultiClusterReplicaSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TMultiClusterReplicaSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TMultiClusterReplicaSet {
   meta: TMultiClusterReplicaSetMeta | undefined;
   spec: TMultiClusterReplicaSetSpec | undefined;
   status: TMultiClusterReplicaSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TMultiClusterReplicaSetControl | undefined;
}

export interface TNannyServiceMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   project_id: string;
}

export interface TNannyServiceControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TNannyService {
   meta: TNannyServiceMeta | undefined;
   spec: TNannyServiceSpec | undefined;
   status: TNannyServiceStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNannyServiceControl | undefined;
}

export interface TNotificationInfoMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TNotificationInfoControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TNotificationInfo {
   meta: TNotificationInfoMeta | undefined;
   spec: TNotificationInfoSpec | undefined;
   status: TNotificationInfoStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNotificationInfoControl | undefined;
}

export interface TNotificationPolicyMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TNotificationPolicyControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TNotificationPolicy {
   meta: TNotificationPolicyMeta | undefined;
   spec: TNotificationPolicySpec | undefined;
   status: TNotificationPolicyStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TNotificationPolicyControl | undefined;
}

export interface TPersistentDiskMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   kind: EPersistentDiskKind;
}

export interface TPersistentDiskControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TPersistentDisk {
   meta: TPersistentDiskMeta | undefined;
   spec: TPersistentDiskSpec | undefined;
   status: TPersistentDiskStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPersistentDiskControl | undefined;
}

export interface TPersistentVolumeClaimMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TPersistentVolumeClaimControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TPersistentVolumeClaim {
   meta: TPersistentVolumeClaimMeta | undefined;
   spec: TPersistentVolumeClaimSpec | undefined;
   status: TPersistentVolumeClaimStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPersistentVolumeClaimControl | undefined;
}

export interface TPersistentVolumeMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   disk_id: string;
}

export interface TPersistentVolumeControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TPersistentVolume {
   meta: TPersistentVolumeMeta | undefined;
   spec: TPersistentVolumeSpec | undefined;
   status: TPersistentVolumeStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TPersistentVolumeControl | undefined;
}

export interface TProjectMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   owner_id: string;
}

export interface TProjectControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TProject {
   meta: TProjectMeta | undefined;
   spec: TProjectSpec | undefined;
   status: TProjectStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TProjectControl | undefined;
}

export interface TRelationMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   from_fqid: string;
   to_fqid: string;
   kind: ERelationKind;
}

export interface TRelationControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TRelation {
   meta: TRelationMeta | undefined;
   spec: TRelationSpec | undefined;
   status: TRelationStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TRelationControl | undefined;
}

export interface TReleaseMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   author_id: string;
}

export interface TReleaseControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TRelease {
   meta: TReleaseMeta | undefined;
   spec: TReleaseSpec | undefined;
   status: TReleaseStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TReleaseControl | undefined;
}

export interface TReleaseRuleMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TReleaseRuleControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TReleaseRule {
   meta: TReleaseRuleMeta | undefined;
   spec: TReleaseRuleSpec | undefined;
   status: TReleaseRuleStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TReleaseRuleControl | undefined;
}

export interface TReplicaSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TReplicaSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TReplicaSet {
   meta: TReplicaSetMeta | undefined;
   spec: TReplicaSetSpec | undefined;
   status: TReplicaSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TReplicaSetControl | undefined;
}

export interface TResourceCacheMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   pod_set_id: string;
}

export interface TResourceCacheControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TResourceCache {
   meta: TResourceCacheMeta | undefined;
   spec: TResourceCacheSpec | undefined;
   status: TResourceCacheStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TResourceCacheControl | undefined;
}

export interface TSecretMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TSecretControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TSecret {
   meta: TSecretMeta | undefined;
   spec: TSecretSpec | undefined;
   status: TSecretStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TSecretControl | undefined;
}

export interface TSemaphoreMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   semaphore_set_id: string;
}

export interface TSemaphoreControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   /**
    *  Custom fields:
    */
   acquire: TSemaphoreAcquire | undefined;
   ping: TSemaphorePing | undefined;
   release: TSemaphoreRelease | undefined;
}

export interface TSemaphore {
   meta: TSemaphoreMeta | undefined;
   spec: TSemaphoreSpec | undefined;
   status: TSemaphoreStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TSemaphoreControl | undefined;
}

export interface TSemaphoreSetMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
}

export interface TSemaphoreSetControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
   /**
    *  Custom fields:
    */
   acquire: TSemaphoreSetAcquire | undefined;
   ping: TSemaphoreSetPing | undefined;
   release: TSemaphoreSetRelease | undefined;
}

export interface TSemaphoreSet {
   meta: TSemaphoreSetMeta | undefined;
   spec: TSemaphoreSetSpec | undefined;
   status: TSemaphoreSetStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TSemaphoreSetControl | undefined;
}

export interface TStageDraftMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   stage_id: string;
}

export interface TStageDraftControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TStageDraft {
   meta: TStageDraftMeta | undefined;
   spec: TStageDraftSpec | undefined;
   status: TStageDraftStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TStageDraftControl | undefined;
}

export interface TStageMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   acl: TAccessControlEntry[];
   /**
    *  Custom fields:
    */
   project_id: string;
}

export interface TStage {
   meta: TStageMeta | undefined;
   spec: TStageSpec | undefined;
   status: TStageStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TStageControl | undefined;
}

export interface TSystemServiceConfigMeta {
   id: string;
   uuid: string;
   name: string;
   fqid: string;
   key: string;
   parent_key: string;
   account_id: string;
   effective_account_id: string;
   type: EObjectType;
   creation_time: number;
   inherit_acl: boolean;
   /**
    *  Custom fields:
    */
   acl: TAccessControlEntry[];
}

export interface TSystemServiceConfigControl {
   add_deploy_child: TAddDeployChild | undefined;
   remove_deploy_child: TRemoveDeployChild | undefined;
   add_secret_delegation: TAddSecretDelegation | undefined;
   remove_secret_delegation: TRemoveSecretDelegation | undefined;
}

export interface TSystemServiceConfig {
   meta: TSystemServiceConfigMeta | undefined;
   spec: TSystemServiceConfigSpec | undefined;
   status: TSystemServiceConfigStatus | undefined;
   labels: TAttributeDictionary | undefined;
   annotations: TAttributeDictionary | undefined;
   control: TSystemServiceConfigControl | undefined;
}
